	function [A] = bp_atten_epb(Z,NIN,NZ,q,Z_vec,Amax)
	% 
	% Calculates the attenuation A(Z_vec) in the stopband 
	% Z-frequencies Z_vec given an attenuation pole vector Z
	% for the BP case with equiripple passband.
	%
	% Also the number of attenuation poles at infinity NIN 
	% and the number at the origin NZ is required. q is the 
	% passband quotient wb/wb.
	
	% Author: 			Per Loewenborg
    % Modified by:		LW
	% Copyright:		by authors - not released for commercial use
	% Version: 			1	
	% Known bugs:		None
	% Report bugs to:	larsw@isy.liu.se
	
	L = ones(1,length(Z_vec));
	N = length(Z);
	for k = 1:N
		L = L.*(Z_vec+Z(k));
		L = L./(Z_vec-Z(k)); 
	end
	L = L.*( (Z_vec+1).^(NIN/2) );
	L = L./( (Z_vec-1).^(NIN/2) );
	L = L.*( (Z_vec+q).^(NZ/2) );
	L = L./( (Z_vec-q).^(NZ/2) );
	
	ep_sqred = (10^(0.1*Amax)) - 1;
	A = 10*log10(1 + ((ep_sqred/4)*((abs(L)+(1./abs(L))).^2)) );
